/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.engine;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.nooj4nlp.controller.TextEditorShell.JMftPanel;
import net.nooj4nlp.engine.Dic;
import net.nooj4nlp.engine.RefObject;
import net.nooj4nlp.engine.helper.PenAttributes;

public class TuGraph {
    public ArrayList<Double> stPositions;
    public ArrayList<ArrayList<TransCell>> transitions;
    private int gHeight = 0;
    private int gWidth = 0;
    public int xCoord;
    private int yCoord;
    private int[] stateNumber;
    private int[] colNumber;
    private int[] x;
    private int[] yc;
    private int lastX;
    private HashMap<String, PenAttributes<Color, Float>> pen = new HashMap();
    private Font font;
    private Font font_col;
    private Color brush;
    private Color brush_col;
    private Color brush_sel;
    public boolean needToBeComputed;
    public int currentFrameX;
    public double selectedAnnotation_relBegAddress;
    public int selectedAnnotation_tokenId;
    private int shift = 10;

    public TuGraph() {
        this.stPositions = new ArrayList();
        this.transitions = new ArrayList();
        this.pen.put("pen", new PenAttributes(Color.BLACK, 1.0f));
        this.brush = Color.BLACK;
        this.pen.put("pen_sel", new PenAttributes(Color.RED, 5.0f));
        this.brush_sel = Color.RED;
        this.pen.put("pen_col", new PenAttributes(Color.GRAY, 2.0f));
        this.brush_col = Color.BLUE;
    }

    public void addTransition(double strtPos, int tokenId, double destPos) {
        int idst;
        int isrc;
        if (this.stPositions.indexOf(strtPos) == -1) {
            this.stPositions.add(strtPos);
            isrc = this.stPositions.lastIndexOf(strtPos);
            this.transitions.add(new ArrayList());
        } else {
            isrc = this.stPositions.indexOf(strtPos);
        }
        if (this.stPositions.indexOf(destPos) == -1) {
            this.stPositions.add(destPos);
            idst = this.stPositions.lastIndexOf(destPos);
            this.transitions.add(new ArrayList());
        } else {
            idst = this.stPositions.indexOf(destPos);
        }
        ArrayList<TransCell> trans = this.transitions.get(isrc);
        TransCell tr = new TransCell(tokenId, idst);
        boolean found = false;
        for (TransCell ctr : trans) {
            if (tr.tokenId != ctr.tokenId || tr.dest != ctr.dest) continue;
            found = true;
            break;
        }
        if (!found) {
            trans.add(tr);
        }
    }

    public void computeXYcoord(JPanel mftPanel, double selectAllAnnotationsAtPosition, int y) {
        this.xCoord = 0;
        if (mftPanel.getComponentOrientation() == ComponentOrientation.RIGHT_TO_LEFT) {
            this.xCoord = mftPanel.getWidth() - 1;
        }
        this.yCoord = 10 + (y + 20) / 40 * 40;
        if (this.stateNumber == null) {
            return;
        }
        for (int iCol = 0; iCol < this.stateNumber.length; ++iCol) {
            int iState = this.stateNumber[iCol];
            int statePos = (int)(100.0 * this.stPositions.get(iState));
            int x0 = mftPanel.getComponentOrientation() == ComponentOrientation.RIGHT_TO_LEFT ? this.lastX - this.x[iCol] : this.x[iCol];
            double sp = (double)statePos / 100.0;
            if (sp != selectAllAnnotationsAtPosition) continue;
            this.xCoord = mftPanel.getComponentOrientation() == ComponentOrientation.RIGHT_TO_LEFT ? x0 - (this.currentFrameX - mftPanel.getWidth()) : x0 - this.currentFrameX;
            if (this.xCoord < 0) {
                this.xCoord = 0;
            }
            return;
        }
    }

    public void computeCurrentFrameX(double selectAllAnnotationsAtPosition, JPanel mftPanel) {
        this.currentFrameX = 0;
        if (this.stateNumber == null) {
            return;
        }
        for (int iCol = 0; iCol < this.stateNumber.length; ++iCol) {
            int iState = this.stateNumber[iCol];
            int statePos = (int)(100.0 * this.stPositions.get(iState));
            int x0 = mftPanel.getComponentOrientation() == ComponentOrientation.RIGHT_TO_LEFT ? this.lastX - this.x[iCol] : this.x[iCol];
            double sp = (double)statePos / 100.0;
            if (sp != selectAllAnnotationsAtPosition) continue;
            this.currentFrameX = mftPanel.getComponentOrientation() == ComponentOrientation.RIGHT_TO_LEFT ? ((x0 - 1) / mftPanel.getWidth() + 1) * mftPanel.getWidth() : x0 / mftPanel.getWidth() * mftPanel.getWidth();
        }
    }

    public void computeDrawing(ArrayList<Object> annotations, JMftPanel mftPanel, Graphics2D g) {
        int iTrans;
        int iCol;
        int iCol2;
        this.font = mftPanel.getFont();
        this.font_col = new Font(mftPanel.getFont().getName(), 0, 8);
        int nbOfStates = this.stPositions.size();
        if (nbOfStates == 0) {
            this.stateNumber = null;
            return;
        }
        this.stateNumber = new int[nbOfStates];
        for (int i = 0; i < nbOfStates; ++i) {
            this.stateNumber[i] = i;
        }
        for (iCol2 = 0; iCol2 < nbOfStates; ++iCol2) {
            int si = this.stateNumber[iCol2];
            int posi = (int)(100.0 * this.stPositions.get(si));
            for (int jCol = iCol2 + 1; jCol < nbOfStates; ++jCol) {
                int sj = this.stateNumber[jCol];
                int posj = (int)(100.0 * this.stPositions.get(sj));
                if (posi <= posj) continue;
                int coltmp = this.stateNumber[iCol2];
                this.stateNumber[iCol2] = this.stateNumber[jCol];
                this.stateNumber[jCol] = coltmp;
                si = this.stateNumber[iCol2];
                posi = (int)(100.0 * this.stPositions.get(si));
            }
        }
        this.colNumber = new int[nbOfStates];
        for (iCol2 = 0; iCol2 < nbOfStates; ++iCol2) {
            this.colNumber[this.stateNumber[iCol2]] = iCol2;
        }
        this.x = new int[nbOfStates];
        for (int icol = 0; icol < nbOfStates; ++icol) {
            this.x[icol] = icol * 20;
        }
        boolean modified = true;
        while (modified) {
            modified = false;
            for (iCol = 0; iCol < nbOfStates; ++iCol) {
                int iState = this.stateNumber[iCol];
                ArrayList<TransCell> trans = this.transitions.get(iState);
                for (iTrans = 0; iTrans < trans.size(); ++iTrans) {
                    String lbl;
                    String[] features;
                    RefObject<Object> refFeatures;
                    String category;
                    RefObject<String> refCategory;
                    String lemma;
                    RefObject<String> refLemma;
                    String entry;
                    RefObject<String> refEntry;
                    TransCell t = trans.get(iTrans);
                    int tkId = t.tokenId;
                    String lbl0 = tkId < 0 || tkId >= annotations.size() ? "ANNOTATION,ERROR" : (String)annotations.get(tkId);
                    if (lbl0 == null || !Dic.parseDELAF(lbl0, refEntry = new RefObject<String>(entry = ""), refLemma = new RefObject<String>(lemma = ""), null, refCategory = new RefObject<String>(category = ""), null, refFeatures = new RefObject<Object>((features = null)))) continue;
                    entry = (String)refEntry.argvalue;
                    lemma = (String)refLemma.argvalue;
                    category = (String)refCategory.argvalue;
                    features = (String[])refFeatures.argvalue;
                    if (category.equals("NW") || features != null && Dic.lookFor("FXC", null, features) != null) continue;
                    if (lemma.equals("SYNTAX")) {
                        lbl = category + Dic.getRidOfSpecialFeaturesPlus(features);
                    } else {
                        String newFeatures = Dic.getRidOfSpecialFeaturesPlus(features);
                        lbl = lemma + "," + category + newFeatures;
                    }
                    int width = this.measureText(g, lbl, this.font);
                    int jState = t.dest;
                    int jCol = this.colNumber[jState];
                    if (jCol == iCol || width <= this.x[jCol] - this.x[iCol]) continue;
                    int oldRightMargin = this.x[jCol];
                    int newRightMargin = this.x[iCol] + width + 1;
                    for (int k = 0; k < nbOfStates; ++k) {
                        if (this.x[k] < oldRightMargin) continue;
                        this.x[k] = newRightMargin + (this.x[k] - oldRightMargin);
                        modified = true;
                    }
                }
            }
        }
        this.lastX = this.x[this.stateNumber.length - 1];
        for (int iState = 0; iState < nbOfStates; ++iState) {
            ArrayList<TransCell> trans = this.transitions.get(iState);
            for (int i = 0; i < trans.size(); ++i) {
                for (int j = i + 1; j < trans.size(); ++j) {
                    int desI = (int)(100.0 * this.stPositions.get(trans.get(i).dest));
                    String labI = (String)annotations.get(trans.get(i).tokenId);
                    int desJ = (int)(100.0 * this.stPositions.get(trans.get(j).dest));
                    int tokId = trans.get(j).tokenId;
                    String labJ = tokId < 0 || tokId >= annotations.size() ? "annotation,INVALIDRANGE" : (String)annotations.get(tokId);
                    if (desI >= desJ) continue;
                    TransCell tmp = trans.get(i);
                    trans.set(i, trans.get(j));
                    trans.set(j, tmp);
                }
            }
        }
        this.yc = new int[nbOfStates];
        for (iCol = 0; iCol < nbOfStates; ++iCol) {
            int iState = this.stateNumber[iCol];
            ArrayList<TransCell> trans = this.transitions.get(iState);
            if (this.yc[iCol] == 0) {
                this.yc[iCol] = 50;
            }
            for (iTrans = 0; iTrans < trans.size(); ++iTrans) {
                TransCell t = trans.get(iTrans);
                int curry = this.yc[iCol] + 40 * iTrans;
                for (int jcol = iCol + 1; jcol < nbOfStates; ++jcol) {
                    int jState = this.stateNumber[jcol];
                    if ((int)(100.0 * this.stPositions.get(t.dest)) <= (int)(100.0 * this.stPositions.get(jState)) || this.yc[jcol] >= curry + 40) continue;
                    this.yc[jcol] = curry + 40;
                }
            }
        }
        this.gWidth = this.x[nbOfStates - 1];
        this.gHeight = 0;
        for (int icol = 0; icol < nbOfStates; ++icol) {
            int iState = this.stateNumber[icol];
            ArrayList<TransCell> trans = this.transitions.get(iState);
            if (this.gHeight >= this.yc[icol] + 40 * trans.size()) continue;
            this.gHeight = this.yc[icol] + 40 * trans.size();
        }
        mftPanel.setSize(this.gWidth, this.gHeight);
        this.needToBeComputed = false;
    }

    public boolean getSelectedAnnotation(int xClick, int yClick, JPanel mftPanel, RefObject<Double> selectAllAnnotationsAtPosition) {
        if (this.stateNumber == null) {
            selectAllAnnotationsAtPosition.argvalue = 0.0;
            return false;
        }
        int largestX = -1;
        if (mftPanel.getComponentOrientation() == ComponentOrientation.RIGHT_TO_LEFT) {
            largestX = mftPanel.getWidth() + 1;
        }
        int iCol0 = -1;
        for (int iCol = 0; iCol < this.stateNumber.length; ++iCol) {
            int x0;
            int colX;
            if (mftPanel.getComponentOrientation() == ComponentOrientation.RIGHT_TO_LEFT) {
                colX = this.lastX - this.x[iCol];
                if (colX > this.currentFrameX) continue;
                if (colX < this.currentFrameX - mftPanel.getWidth()) break;
                x0 = colX - (this.currentFrameX - mftPanel.getWidth());
                if (x0 <= xClick || x0 >= largestX) continue;
                largestX = x0;
                iCol0 = iCol;
                continue;
            }
            colX = this.x[iCol];
            if (colX < this.currentFrameX) continue;
            if (colX > this.currentFrameX + mftPanel.getWidth()) break;
            x0 = colX - this.currentFrameX;
            if (x0 >= xClick || x0 <= largestX) continue;
            largestX = x0;
            iCol0 = iCol;
        }
        if (iCol0 == -1) {
            selectAllAnnotationsAtPosition.argvalue = 0.0;
            return false;
        }
        int istate0 = this.stateNumber[iCol0];
        selectAllAnnotationsAtPosition.argvalue = (double)this.stPositions.get(istate0);
        return true;
    }

    public void draw(ArrayList<Object> annotations, double selectAllAnnotationsAtPosition, JMftPanel mftPanel, Graphics2D g) {
        JScrollPane parent = mftPanel.getParentScrollPane();
        g.setColor(parent.getBackground());
        g.fillRect(0, 0, parent.getWidth(), parent.getHeight());
        this.computeCurrentFrameX(selectAllAnnotationsAtPosition, mftPanel);
        this.selectedAnnotation_relBegAddress = -1.0;
        this.selectedAnnotation_tokenId = -1;
        if (this.stateNumber == null) {
            return;
        }
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, mftPanel.getWidth(), this.gHeight);
        g.setColor((Color)this.pen.get((Object)"pen_col").color);
        g.setStroke(new BasicStroke(this.pen.get((Object)"pen_col").stroke));
        g.drawRect(0, 0, mftPanel.getWidth(), this.gHeight);
        ArrayList allXRefs = new ArrayList();
        block0: for (int iCol = 0; iCol < this.stateNumber.length; ++iCol) {
            int x0;
            int iState = this.stateNumber[iCol];
            int statePos = (int)(100.0 * (this.stPositions.get(iState) + 0.005));
            ArrayList<TransCell> trans = this.transitions.get(iState);
            if (mftPanel.getComponentOrientation() == ComponentOrientation.RIGHT_TO_LEFT) {
                x0 = this.lastX - this.x[iCol];
                if (x0 < 0) break;
                if (x0 > this.currentFrameX) continue;
                x0 -= this.currentFrameX - mftPanel.getWidth();
            } else {
                x0 = this.x[iCol];
                if (x0 > this.currentFrameX + mftPanel.getWidth()) break;
                if (x0 < this.currentFrameX) continue;
                x0 -= this.currentFrameX;
            }
            double sp = (double)statePos / 100.0;
            String colNb = Integer.toString((int)sp);
            if (sp == selectAllAnnotationsAtPosition) {
                this.selectedAnnotation_relBegAddress = sp;
                g.setColor((Color)this.pen.get((Object)"pen_sel").color);
                g.setStroke(new BasicStroke(this.pen.get((Object)"pen_sel").stroke));
                g.drawLine(x0, 0, x0, mftPanel.getHeight());
                if (trans.size() > 0) {
                    g.setColor(this.brush_sel);
                    g.setFont(this.font_col);
                    g.drawString(colNb, x0, 0 + this.shift);
                }
            } else {
                g.setColor((Color)this.pen.get((Object)"pen_col").color);
                g.setStroke(new BasicStroke(this.pen.get((Object)"pen_col").stroke));
                g.drawLine(x0, 0, x0, mftPanel.getHeight());
                if (trans.size() > 0) {
                    g.setColor(this.brush_col);
                    g.setFont(this.font_col);
                    g.drawString(colNb, x0, 0 + this.shift);
                }
            }
            for (int it = 0; it < trans.size(); ++it) {
                Color tBrush;
                BasicStroke tStroke;
                Color tPen;
                String label;
                Color color;
                String[] features;
                RefObject<Object> refFeatures;
                String category;
                RefObject<String> refCategory;
                String lemma;
                RefObject<String> refLemma;
                String entry;
                RefObject<String> refEntry;
                int x1;
                TransCell t = trans.get(it);
                int tokenId = t.tokenId;
                if (mftPanel.getComponentOrientation() == ComponentOrientation.RIGHT_TO_LEFT) {
                    x1 = this.lastX - this.x[this.colNumber[t.dest]];
                    if (x1 < 0) continue block0;
                    x1 -= this.currentFrameX - mftPanel.getWidth();
                } else {
                    x1 = this.x[this.colNumber[t.dest]];
                    if (x1 > this.currentFrameX + mftPanel.getWidth()) continue block0;
                    x1 -= this.currentFrameX;
                }
                int y = this.yc[iCol] + 40 * it;
                int yt = y - 20;
                String label0 = tokenId < 0 || tokenId >= annotations.size() ? "annotations,INVALIDRANGE" : (String)annotations.get(tokenId);
                if (label0 == null || !Dic.parseDELAF(label0, refEntry = new RefObject<String>(entry = ""), refLemma = new RefObject<String>(lemma = ""), null, refCategory = new RefObject<String>(category = ""), null, refFeatures = new RefObject<Object>((features = null)))) continue;
                entry = (String)refEntry.argvalue;
                lemma = (String)refLemma.argvalue;
                category = (String)refCategory.argvalue;
                features = (String[])refFeatures.argvalue;
                if (category.equals("NW") || features != null && Dic.lookFor("FXC", null, features) != null) continue;
                if (lemma.equals("SYNTAX")) {
                    color = new Color(20, 180, 62);
                    label = category + Dic.getRidOfSpecialFeaturesPlus(features);
                } else {
                    color = Color.BLACK;
                    String newFeatures = Dic.getRidOfSpecialFeaturesPlus(features);
                    label = Dic.protectComma(lemma) + "," + category + newFeatures;
                }
                if (color == Color.BLACK) {
                    if (y == this.yCoord && sp == selectAllAnnotationsAtPosition) {
                        this.selectedAnnotation_tokenId = tokenId;
                        tPen = (Color)this.pen.get((Object)"pen_sel").color;
                        tStroke = new BasicStroke(this.pen.get((Object)"pen_sel").stroke);
                        tBrush = this.brush_sel;
                    } else {
                        tPen = (Color)this.pen.get((Object)"pen").color;
                        tStroke = new BasicStroke(this.pen.get((Object)"pen").stroke);
                        tBrush = this.brush;
                    }
                    g.setColor(tPen);
                    g.setStroke(tStroke);
                    g.drawLine(x0, y, x1, y);
                    if (mftPanel.getComponentOrientation() == ComponentOrientation.RIGHT_TO_LEFT) {
                        g.drawLine(x1 + 10, y - 4, x1, y);
                        g.drawLine(x1 + 10, y + 4, x1, y);
                    } else {
                        g.drawLine(x1 - 10, y - 4, x1, y);
                        g.drawLine(x1 - 10, y + 4, x1, y);
                    }
                    if (mftPanel.getComponentOrientation() == ComponentOrientation.RIGHT_TO_LEFT) {
                        g.setColor(tBrush);
                        g.setFont(this.font);
                        g.drawString(label, x1, yt);
                        continue;
                    }
                    g.setColor(tBrush);
                    g.setFont(this.font);
                    g.drawString(label, x0, yt);
                    continue;
                }
                if (y == this.yCoord && sp == selectAllAnnotationsAtPosition) {
                    this.selectedAnnotation_tokenId = tokenId;
                    tPen = (Color)this.pen.get((Object)"pen_sel").color;
                    tStroke = new BasicStroke(this.pen.get((Object)"pen_sel").stroke);
                    tBrush = this.brush_sel;
                } else {
                    tPen = color;
                    tStroke = new BasicStroke(2.0f);
                    tBrush = color;
                }
                g.setColor(tPen);
                g.setStroke(tStroke);
                g.drawLine(x0, y, x1, y);
                if (mftPanel.getComponentOrientation() == ComponentOrientation.RIGHT_TO_LEFT) {
                    g.drawLine(x1 + 10, y - 4, x1, y);
                    g.drawLine(x1 + 10, y + 4, x1, y);
                } else {
                    g.drawLine(x1 - 10, y - 4, x1, y);
                    g.drawLine(x1 - 10, y + 4, x1, y);
                }
                if (mftPanel.getComponentOrientation() == ComponentOrientation.RIGHT_TO_LEFT) {
                    g.setColor(tBrush);
                    g.setFont(this.font);
                    g.drawString(label, x1, yt);
                    continue;
                }
                g.setColor(tBrush);
                g.setFont(this.font);
                g.drawString(label, x0, yt);
            }
        }
        int lastcol = this.stateNumber.length - 1;
        if (mftPanel.getComponentOrientation() == ComponentOrientation.RIGHT_TO_LEFT) {
            g.setStroke(new BasicStroke(this.pen.get((Object)"pen_col").stroke));
            g.setColor((Color)this.pen.get((Object)"pen_col").color);
            g.drawLine(this.lastX - this.x[lastcol], 0, this.lastX - this.x[lastcol], mftPanel.getHeight());
        } else {
            g.setStroke(new BasicStroke(this.pen.get((Object)"pen_col").stroke));
            g.setColor((Color)this.pen.get((Object)"pen_col").color);
            g.drawLine(this.x[lastcol], 0, this.x[lastcol], mftPanel.getHeight());
        }
        mftPanel.setPreferredSize(new Dimension(mftPanel.getWidth(), mftPanel.getHeight()));
    }

    private int measureText(Graphics2D g, String text, Font f) {
        Font previousFont = g.getFont();
        g.setFont(f);
        FontMetrics metrics = g.getFontMetrics();
        g.setFont(previousFont);
        return metrics.stringWidth(text);
    }

    public void setNeedToBeComputed(boolean needToBeComputed) {
        this.needToBeComputed = needToBeComputed;
    }

    public void setTransitions(ArrayList<ArrayList<TransCell>> transitions) {
        this.transitions = transitions;
    }

    public class TransCell {
        private int tokenId;
        private int dest;

        private TransCell(int tokenid, int dst) {
            this.tokenId = tokenid;
            this.dest = dst;
        }
    }
}

